#include "precompiled.h"
#include "Texture1D.h"
#include "common.h"

namespace RTCam {

Texture1D::Texture1D(_In_z_ const char* name) :
	Resource(name),
	m_texture(nullptr),
	m_shaderView(nullptr),
	m_width(0),
	m_mipmapEnabled(false)
{
}


Texture1D::~Texture1D(void)
{
}

void Texture1D::InitTexture(_In_ ID3D11Device1* device, size_t width, DXGI_FORMAT texFormat, DXGI_FORMAT srvFormat, int bindFlags, const void* initialData, bool mipmapEnabled)
{
	m_mipmapEnabled = mipmapEnabled;
	m_width = width;

	size_t mipLevels = 1;
	size_t miscFlags = 0;

	if(mipmapEnabled) {
		mipLevels = 0; // 0 = automatically generate max number of mip levels
		miscFlags = D3D11_RESOURCE_MISC_GENERATE_MIPS;
	}

	D3D11_SUBRESOURCE_DATA textureData = {0};
	textureData.pSysMem = initialData;
	textureData.SysMemPitch = 0;
	textureData.SysMemSlicePitch = 0;

	D3D11_SUBRESOURCE_DATA* pData = nullptr;
	if(initialData != nullptr) {
		pData = &textureData;
	}

	// Create the texture
	CD3D11_TEXTURE1D_DESC textureDesc(
		texFormat,
		width,
		1,								// Only one texture (not a texture array)
		mipLevels,						// Number of mip levels (0 = auto)
		bindFlags,
		D3D11_USAGE_DEFAULT,
		0,								// CPU access flags
		miscFlags
		);

	ThrowIfFailed(
		device->CreateTexture1D(
		&textureDesc,
		pData,
		&m_texture
		)
		);

	// Create the shader resource view
	CD3D11_SHADER_RESOURCE_VIEW_DESC shaderResourceDesc(
		D3D11_SRV_DIMENSION_TEXTURE1D,
		srvFormat,
		0,
		-1
		);
	ThrowIfFailed(
		device->CreateShaderResourceView(
		m_texture.Get(),
		&shaderResourceDesc,
		&m_shaderView
		)
		);

	SetDebugObjectName(m_texture.Get(), m_name + "Texture");
	SetDebugObjectName(m_shaderView.Get(), m_name + "ShaderView");
}

void Texture1D::InitFromChart( _In_ ID3D11Device1* device, _In_ float* chartValues, size_t dataLength )
{
	InitTexture(device, dataLength, DXGI_FORMAT_R32_FLOAT, DXGI_FORMAT_R32_FLOAT, D3D11_BIND_SHADER_RESOURCE, static_cast<void*>(chartValues));
}

} // end namespace